# 1. Make the Bioanalyzer graphs for the MiSeq data

Create figures showing the Bioanalyzer distributions for the MiSeq time course and knockdown samples:

```
python -i make_figure_MiSeq.py
```

This generates the figures `figure_bioanalyzer_miseq.png` and `figure_bioanalyzer_miseq_zoomed.png` showing the distributions before size selection,
the figures `figure_bioanalyzer_miseq_separate.png` and `figure_bioanalyzer_miseq_separate_zoomed.png` showing the distributions before size selection for each sample separately,
and the figures `figure_bioanalyzer_miseq_before_after.png` and `figure_bioanalyzer_miseq_before_after_zoomed.png` showing the distribution before size selection for sample #8 (time course 4 hours time point, replicate 2) and after size selection for the 36-mix library.

Make a figure with the distribution of RNA length for the sequenced reads:
```
python -i make_figure_MiSeq_sequencing.py 
```
generating the figure `figure_sequencing_miseq_timecourse.png` for the time course samples, and `figure_sequencing_miseq_knockdown.png` for the knockdown samples.

The numbers in each subplot are the number of reads with an inferred size within the selected range, the number of reads with an inferred size outside of the selected range, and the number of unmapped reads (for which the size cannot be inferred). The "Protocol negative control" library was produced without the 3' linker.

# 2. Make the Bioanalyzer graphs for the HiSeq data

Create four figures showing the Bioanalyzer distributions before and after size selection:
```
python -i make_figure_HiSeq.py
```
generating the following four figures:

`figure_bioanalyzer_hiseq_separate.png`: Bioanalyzer profile for each sample separately, before size selection.

`figure_bioanalyzer_hiseq_separate_zoomed.png`: Bioanalyzer profile for each sample separately, before size selection, zoomed in on the selected sizes.

`figure_bioanalyzer_hiseq.png`: Bioanalyzer profile of the combined 18-mix library, after size selection, together with the profiles for each sample separately before size selection.

`figure_bioanalyzer_hiseq_zoomed.png`: Bioanalyzer profile of the combined 18-mix library, after size selection, together with the profiles for each sample separately before size selection, zoomed in on the selected sizes.
